/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.io;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class MultiAccessFileSystem
implements Closeable {
    private final FileSystem delegate;
    private final List<Lens> lenses = new LinkedList<Lens>();
    private boolean closed = false;

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MultiAccessFileSystem wrap(FileSystem delegate) {
        return new MultiAccessFileSystem(delegate);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MultiAccessFileSystem create(URI uri) throws IOException {
        return MultiAccessFileSystem.wrap(FileSystems.getFileSystem(uri));
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MultiAccessFileSystem create(URI uri, ClassLoader loader) throws IOException {
        return MultiAccessFileSystem.wrap(FileSystems.newFileSystem(uri, Map.of(), loader));
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MultiAccessFileSystem create(URI uri, Map<String, ?> env) throws IOException {
        return MultiAccessFileSystem.wrap(FileSystems.newFileSystem(uri, env));
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MultiAccessFileSystem create(URI uri, Map<String, ?> env, ClassLoader loader) throws IOException {
        return MultiAccessFileSystem.wrap(FileSystems.newFileSystem(uri, env, loader));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MultiAccessFileSystem create(Path path) throws IOException {
        return MultiAccessFileSystem.wrap(FileSystems.newFileSystem(path));
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MultiAccessFileSystem create(Path path, ClassLoader loader) throws IOException {
        return MultiAccessFileSystem.wrap(FileSystems.newFileSystem(path, loader));
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static MultiAccessFileSystem create(Path path, Map<String, ?> env) throws IOException {
        return MultiAccessFileSystem.wrap(FileSystems.newFileSystem(path, env));
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static MultiAccessFileSystem create(Path path, Map<String, ?> env, ClassLoader loader) throws IOException {
        return MultiAccessFileSystem.wrap(FileSystems.newFileSystem(path, env, loader));
    }

    private MultiAccessFileSystem(FileSystem delegate) {
        this.delegate = delegate;
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.lenses.isEmpty()) {
            throw new IOException("Attempted to close multi-access file system with live lenses");
        }
        this.closed = true;
        this.delegate.close();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public synchronized FileSystem createLens() throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        Lens lens = new Lens();
        this.lenses.add(lens);
        return lens;
    }

    private class Lens
    extends FileSystem {
        private Lens() {
        }

        @Override
        public FileSystemProvider provider() {
            return MultiAccessFileSystem.this.delegate.provider();
        }

        @Override
        public void close() throws IOException {
            MultiAccessFileSystem.this.lenses.remove(this);
            if (MultiAccessFileSystem.this.lenses.isEmpty()) {
                MultiAccessFileSystem.this.close();
            }
        }

        @Override
        public boolean isOpen() {
            return MultiAccessFileSystem.this.delegate.isOpen();
        }

        @Override
        public boolean isReadOnly() {
            return MultiAccessFileSystem.this.delegate.isReadOnly();
        }

        @Override
        public String getSeparator() {
            return MultiAccessFileSystem.this.delegate.getSeparator();
        }

        @Override
        public Iterable<Path> getRootDirectories() {
            return MultiAccessFileSystem.this.delegate.getRootDirectories();
        }

        @Override
        public Iterable<FileStore> getFileStores() {
            return MultiAccessFileSystem.this.delegate.getFileStores();
        }

        @Override
        public Set<String> supportedFileAttributeViews() {
            return MultiAccessFileSystem.this.delegate.supportedFileAttributeViews();
        }

        @Override
        @NotNull
        public Path getPath(String s, String ... strings) {
            return MultiAccessFileSystem.this.delegate.getPath(s, strings);
        }

        @Override
        public PathMatcher getPathMatcher(String s) {
            return MultiAccessFileSystem.this.delegate.getPathMatcher(s);
        }

        @Override
        public UserPrincipalLookupService getUserPrincipalLookupService() {
            return MultiAccessFileSystem.this.delegate.getUserPrincipalLookupService();
        }

        @Override
        public WatchService newWatchService() throws IOException {
            return MultiAccessFileSystem.this.delegate.newWatchService();
        }
    }
}

